<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Role $role
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Role'), ['action' => 'edit', $role->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Role'), ['action' => 'delete', $role->id], ['confirm' => __('Are you sure you want to delete # {0}?', $role->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Roles'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Role'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="roles view content">
            <h3><?= h($role->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($role->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Windows') ?></th>
                    <td><?= h($role->windows) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($role->id) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Users') ?></h4>
                <?php if (!empty($role->users)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Refid') ?></th>
                            <th><?= __('Role Id') ?></th>
                            <th><?= __('Name') ?></th>
                            <th><?= __('Contact No') ?></th>
                            <th><?= __('Username') ?></th>
                            <th><?= __('Password') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Last Login') ?></th>
                            <th><?= __('Last Logout') ?></th>
                            <th><?= __('Login Status') ?></th>
                            <th><?= __('Otp') ?></th>
                            <th><?= __('Otp Status') ?></th>
                            <th><?= __('Otp Generated') ?></th>
                            <th><?= __('Avatar') ?></th>
                            <th><?= __('Dob') ?></th>
                            <th><?= __('Sex') ?></th>
                            <th><?= __('Note') ?></th>
                            <th><?= __('Rate') ?></th>
                            <th><?= __('Rate By') ?></th>
                            <th><?= __('Scheds') ?></th>
                            <th><?= __('Time In') ?></th>
                            <th><?= __('Time Out') ?></th>
                            <th><?= __('Current Window') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($role->users as $users) : ?>
                        <tr>
                            <td><?= h($users->id) ?></td>
                            <td><?= h($users->refid) ?></td>
                            <td><?= h($users->role_id) ?></td>
                            <td><?= h($users->name) ?></td>
                            <td><?= h($users->contact_no) ?></td>
                            <td><?= h($users->username) ?></td>
                            <td><?= h($users->password) ?></td>
                            <td><?= h($users->created) ?></td>
                            <td><?= h($users->status) ?></td>
                            <td><?= h($users->last_login) ?></td>
                            <td><?= h($users->last_logout) ?></td>
                            <td><?= h($users->login_status) ?></td>
                            <td><?= h($users->otp) ?></td>
                            <td><?= h($users->otp_status) ?></td>
                            <td><?= h($users->otp_generated) ?></td>
                            <td><?= h($users->avatar) ?></td>
                            <td><?= h($users->dob) ?></td>
                            <td><?= h($users->sex) ?></td>
                            <td><?= h($users->note) ?></td>
                            <td><?= h($users->rate) ?></td>
                            <td><?= h($users->rate_by) ?></td>
                            <td><?= h($users->scheds) ?></td>
                            <td><?= h($users->time_in) ?></td>
                            <td><?= h($users->time_out) ?></td>
                            <td><?= h($users->current_window) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Users', 'action' => 'view', $users->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Users', 'action' => 'edit', $users->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Users', 'action' => 'delete', $users->id], ['confirm' => __('Are you sure you want to delete # {0}?', $users->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
