<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Stolencard $stolencard
 * @var \Cake\Collection\CollectionInterface|string[] $customers
 * @var \Cake\Collection\CollectionInterface|string[] $accounts
 * @var \Cake\Collection\CollectionInterface|string[] $generatedcards
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Stolencards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="stolencards form content">
            <?= $this->Form->create($stolencard) ?>
            <fieldset>
                <legend><?= __('Add Stolencard') ?></legend>
                <?php
                    echo $this->Form->control('customer_id', ['options' => $customers]);
                    echo $this->Form->control('account_id', ['options' => $accounts]);
                    echo $this->Form->control('generatedcard_id', ['options' => $generatedcards]);
                    echo $this->Form->control('card_number');
                    echo $this->Form->control('date_reported', ['empty' => true]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
