<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Stolencard $stolencard
 * @var string[]|\Cake\Collection\CollectionInterface $customers
 * @var string[]|\Cake\Collection\CollectionInterface $accounts
 * @var string[]|\Cake\Collection\CollectionInterface $generatedcards
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $stolencard->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $stolencard->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Stolencards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="stolencards form content">
            <?= $this->Form->create($stolencard) ?>
            <fieldset>
                <legend><?= __('Edit Stolencard') ?></legend>
                <?php
                    echo $this->Form->control('customer_id', ['options' => $customers]);
                    echo $this->Form->control('account_id', ['options' => $accounts]);
                    echo $this->Form->control('generatedcard_id', ['options' => $generatedcards]);
                    echo $this->Form->control('card_number');
                    echo $this->Form->control('date_reported', ['empty' => true]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
