<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Stolencard> $stolencards
 */
?>
<div class="stolencards index content">
    <?= $this->Html->link(__('New Stolencard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Stolencards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('customer_id') ?></th>
                    <th><?= $this->Paginator->sort('account_id') ?></th>
                    <th><?= $this->Paginator->sort('generatedcard_id') ?></th>
                    <th><?= $this->Paginator->sort('card_number') ?></th>
                    <th><?= $this->Paginator->sort('date_reported') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($stolencards as $stolencard): ?>
                <tr>
                    <td><?= $this->Number->format($stolencard->id) ?></td>
                    <td><?= $stolencard->has('customer') ? $this->Html->link($stolencard->customer->id, ['controller' => 'Customers', 'action' => 'view', $stolencard->customer->id]) : '' ?></td>
                    <td><?= $stolencard->has('account') ? $this->Html->link($stolencard->account->id, ['controller' => 'Accounts', 'action' => 'view', $stolencard->account->id]) : '' ?></td>
                    <td><?= $stolencard->has('generatedcard') ? $this->Html->link($stolencard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $stolencard->generatedcard->id]) : '' ?></td>
                    <td><?= h($stolencard->card_number) ?></td>
                    <td><?= h($stolencard->date_reported) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $stolencard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $stolencard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $stolencard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $stolencard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
