"use strict";
var KTSigninTwoSteps = (function () {
    var t, e, resendButton;
	var idleTime = 0;
	
	function resetTimer() {
        idleTime = 0; // Reset the idle timer on any user action
    }

    function timerIncrement() {
        idleTime = idleTime + 1;
        if (idleTime >= 5) { // 5 minutes
           // console.log("5 minutes of inactivity. Logging out.");
            // Perform logout operation here
            //window.location.href = _webroot + "users/logout",// Redirect to logout URL
			
			Swal.fire({
				text: "5 minutes of inactivity. Logging out.",
				icon: "info",
				buttonsStyling: !1,
				confirmButtonText: "Ok, got it!",
				customClass: { confirmButton: "btn btn-danger" },
			}).then(function (result) {
				if (result.isConfirmed) {
					// Redirect to a specific URL when 'Ok' is clicked
					window.location.href = _webroot + "users/logout";
				}
			});
										
            clearInterval(idleInterval); // Clear the interval to stop the timer
        }
    }
	
    return {
        init: function () {
            t = document.querySelector("#kt_sing_in_two_steps_form");
            e = document.querySelector("#kt_sing_in_two_steps_submit");
			resendButton = document.querySelector("#resendotp"); 
			
			
			var firstInput = t.querySelector('input[maxlength="1"]:first-child'); // Get the first input

            // Clear all inputs when the first input is focused
            firstInput.addEventListener('focus', function () {
                var inputs = t.querySelectorAll('input[maxlength="1"]');
                inputs.forEach(function (input) {
                    input.value = ''; // Clear each input
                });
            });
			
			
			
            e.addEventListener("click", function (n) {
                n.preventDefault();
                var i = true,
                    o = [].slice.call(t.querySelectorAll('input[maxlength="1"]')),
                    combinedValue = ''; // Declare combinedValue variable

                // Concatenate the values from each input field
                o.forEach(function (t) {
                    combinedValue += t.value;
                    ("" !== t.value && t.value.length !== 0) || (i = false);
                });

                if (i === true) {
                    e.setAttribute("data-kt-indicator", "on");
                    e.disabled = true;

                    setTimeout(function () {
                        e.removeAttribute("data-kt-indicator");
                        e.disabled = false;
						
						
                        // AJAX request
                        $.ajax({
                            url: _webroot + "users/validateotp",
							type: "POST", 
							contentType: "application/json",
                            data: JSON.stringify({ otp: combinedValue }),
                            headers: {
                                'X-CSRF-Token': $('[name="_csrfToken"]').val()
                            },
                            contentType: "application/json",
                            method: "post",
                            beforeSend: function () {
                                // Before sending AJAX request
                            },
                            success: function (resp) {
                                //var res = JSON.parse(resp);
								//console.log(resp);
								
								 switch(resp.status){
									case 1: //success
										Swal.fire({
											text: resp.message,
											icon: "success",
											buttonsStyling: !1,
											confirmButtonText: "Proceed",
											customClass: { confirmButton: "btn btn-success" },
										}).then(function (result) {
											if (result.isConfirmed) {
												// Redirect to a specific URL when 'Ok' is clicked
												window.location.href = resp.target;
											}
										});
									break;
									case 2: //failed
										Swal.fire({
											text: resp.message,
											icon: "error",
											buttonsStyling: !1,
											confirmButtonText: "Ok, got it!",
											customClass: { confirmButton: "btn btn-danger" },
										}).then(function (result) {
											if (result.isConfirmed) {
												// Redirect to a specific URL when 'Ok' is clicked
												window.location.href = _webroot + "users/logout";
											}
										});
									break;
									default:
										Swal.fire({
											text: resp.message,
											icon: "error",
											buttonsStyling: !1,
											confirmButtonText: "Ok, got it!",
											customClass: { confirmButton: "btn btn-primary" },
										});
									break;
								} 
								
                                
								
								
                            },
                           error: function (xhr, status, error) {
                               console.log('Error:', xhr.responseText); 
                            },
                            complete: function () {
                                // Actions after AJAX complete
                            }
                        });
                    }, 1000);
                } else {
                    swal.fire({
                        text: "Please enter valid security code and try again.",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok, got it!",
                        customClass: { confirmButton: "btn fw-bold btn-light-primary" }
                    }).then(function () {
                        KTUtil.scrollTop();
                    });
                }
            });
			
			
			 // Event listener for Resend OTP button
            resendButton.addEventListener("click", function (n) {
                // AJAX request for resending OTP
				 n.preventDefault();
                 $.ajax({
                            url: _webroot + "users/regenerateOtp",
							contentType: "application/json",
                            headers: {
                                'X-CSRF-Token': $('[name="_csrfToken"]').val()
                            },
                            contentType: "application/json",
                            beforeSend: function () {
                                // Before sending AJAX request
                            },
                            success: function (resp) {
							//console.log(resp);
										Swal.fire({
											text: resp.msg,
											icon: "info",
											buttonsStyling: !1,
											confirmButtonText: "Ok, got it!",
											customClass: { confirmButton: "btn btn-success" },
										});
									
                            },
                           error: function (xhr, status, error) {
                               console.log('Error:', xhr.responseText); 
                            },
                            complete: function () {
                                // Actions after AJAX complete
                            }
                }); 

            });
			
			
			// Set up the idle timer
            var idleInterval = setInterval(timerIncrement, 60000); // 1 minute intervals
            document.addEventListener('mousemove', resetTimer);
            document.addEventListener('keypress', resetTimer);
			
        },
    };
})();
KTUtil.onDOMContentLoaded(function () {
    KTSigninTwoSteps.init();
});
