function getTheWebroot(){
	return ("https:"==document.location.protocol?"https://":"http://") + document.location.hostname + "/SEMPCO/members/admin/";
}

function getTheWebrootMember(){
	return ("https:"==document.location.protocol?"https://":"http://") + document.location.hostname + "/SEMPCO/members/member/";
}

function fileUploadWebroot(){
	return ("https:"==document.location.protocol?"https://":"http://") + document.location.hostname + "/SEMPCO/members";
}


var _webroot = getTheWebroot();
var _webrootmember = getTheWebrootMember();
var _filewebroot = fileUploadWebroot();

$(document).ready(function() {
	getPositionList();
	$(".btn").on("contextmenu",function(){
		  return false;
	}); 
}); 

function getPositionList(){
	if($(".election_id").length) {
		$(".election_id").change( function(){
				var _sel = $(".election_id option:selected").val();
				var _url = "";
				
				if(_sel===""){
					alert("Please select an election.");
					showLoading("hide");
					if($(".position_id").length) {
						$(".position_id").empty();
					}
				}else{
					_url = _webroot + "officerpositions/getList/" + _sel;
					getOptionList(_url, ".position_id");
				} 
		});
	}
}
	

function showLoading(type){
	switch(type){
		case "show":
			$(".loading").loading({
				message: "Fetching Info..."
			});
		break;
		case "hide":
			$(".loading").loading("stop");
		break;
		default:
		
		break;
	}
	
}


function getOptionList(_url, optionid){
	$.ajax({
		method		: "GET",
		url			: _url,
		cache		: false,				
		beforeSend	: function(){
			showLoading("show");	
		},
		success		: function(resp){
			 if ($.isEmptyObject(resp)){
				 alert("Unable to fetch data, please try again.");
			 }else{
				_data = JSON.parse(resp);
				$(optionid).empty();
				if(_data.status===200){
					$(optionid).append($("<option>", { 
						value: "",
						text : "--Choose"
					}));
									
					$.each(_data.data, function (i, item) {
										
						$(optionid).append($("<option>", { 
							value: item.id,
							text : item.name 
						}));
										
					});
				}else{
					alert(_data.message);
				}	
			 }
		},
		error		: function(err1, err2, err3){
			alert("Opps! something went wrong, please try again.");
			showLoading("hide");
		},
		complete	: function(){
			showLoading("hide");
		},				
	});	
}
	
function resetAccount(url){
	 $.confirm({
        title: 'Notification',
                            content: 'You are about to submit the changes. Click Proceed to Confirm',
                            icon: '',
                            animation: 'scale',
                            closeAnimation: 'scale',
                            opacity: 0.5,
                            buttons: {
                                'confirm': {
                                    text: 'Proceed',
                                    btnClass: 'btn-blue',
                                    action: function(){
										$.get(url, function(resp){
											if ($.isEmptyObject(resp)){
												$.alert('Unable to process your request. Please try again in a short while.');
											}else{
												var res = JSON.parse(resp);
												$.alert(res.message);
											}
										 });
													
                                    }
                                },
                                cancel: function(){
                                    $.alert('Submission has been canceled.');
                                },
                            }
                        });
						
}
	
    /* function getCityList(){	
			$(".loc_province").change( function(){
				showLoading("show");
				
					
				//$(".sitio, .address").val("");
				var _sel = $(".loc_region option:selected").val();
				var _sel_pr = $(".loc_province option:selected").val();
				var _url = "";
				if(_sel===""){
					$(".loc_city").empty();
					$(".loc_barangay").empty();
					alert("Please select a Province.");
					showLoading("hide");
				
				}else{
					
					_url = _webroot + "cities/getList/" + _sel + "/" + _sel_pr;
					showLoading("hide");
					getOptionList(_url, ".loc_city");
					$(".loc_barangay").empty();
					getBarangayList();
					//getLocName(_webroot + "provinces/getAddressName/" + _sel_pr, ".address");
				}

			});
	}

	function getBarangayList(){
			$(".loc_city").change( function(){
				showLoading("show");
				//$(".sitio, .address").val("");
				var _sel = $(".loc_region option:selected").val();
				var _sel_pr = $(".loc_province option:selected").val();
				var _sel_ct = $(".loc_city option:selected").val();
				var _url = "";
				if(_sel===""){
					alert("Please select a City.");
					showLoading("hide");
				}else{
					_url = _webroot + "barangays/getList/" + _sel + "/" + _sel_pr + "/" + _sel_ct;
					showLoading("hide");
					getOptionList(_url, ".loc_barangay");
					//generateAddress();
					//getLocName(_webroot + "cities/getAddressName/" + _sel_ct, ".address");
				}
			});
	}
	 */
	